#include <FTPEx.au3>
#include <array.au3>
;new
$Open = _FTP_Open('MyFTP Control')
$Connect = _FTP_Connect($Open, 'ftp.mozilla.org', '', '')
If Not @error Then ConsoleWrite('Connection Successful.' & @CRLF)

_FTP_DirSetCurrent($Connect, '/pub')
If Not @error Then ConsoleWrite('Current Directory = ' & _FTP_DirGetCurrent($Connect) & @CRLF)

$Filelist = _FTP_ListToArrayEx2($Connect, 0);dirs and files
_ArrayDisplay($Filelist, 'Dirs and Files')
$Filelist = _FTP_ListToArrayEx2($Connect, 1);dirs
_ArrayDisplay($Filelist, 'Dirs Only')
$Filelist = _FTP_ListToArrayEx2($Connect, 2);files
_ArrayDisplay($Filelist, 'Files Only')

_FTP_Close($Connect)

;old
$Open = _FTP_Open('MyFTP Control')
$Connect = _FTP_Connect($Open, 'ftp.mozilla.org', '', '')
If Not @error Then ConsoleWrite('Connection Successful.' & @CRLF)

_FTP_DirSetCurrent($Connect, '/pub')
If Not @error Then ConsoleWrite('Current Directory = ' & _FTP_DirGetCurrent($Connect) & @CRLF)

$Filelist = _FTP_ListToArrayEx($Connect, 0);dirs and files
_ArrayDisplay($Filelist, 'Dirs and Files')
$Filelist = _FTP_ListToArrayEx($Connect, 1);dirs
_ArrayDisplay($Filelist, 'Dirs Only - Fail')
$Filelist = _FTP_ListToArrayEx($Connect, 2);files
_ArrayDisplay($Filelist, 'Files Only - Fail')

_FTP_Close($Connect)


Func _FTP_ListToArrayEx2($l_FTPSession, $Return_Type = 0, $l_Flags = 0, $b_Fmt = 1, $l_Context = 0)
	If $__ghWinInet_FTP = -1 Then Return SetError(-2, 0, 0)
	Return __FTP_ListToArray2($l_FTPSession, $Return_Type, $l_Flags, $b_Fmt, 6, $l_Context)
EndFunc   ;==>_FTP_ListToArrayEx

Func __FTP_ListToArray2($l_FTPSession, $Return_Type = 0, $l_Flags = 0, $bFmt = 1, $ArrayCount = 6, $l_Context = 0)
	Local $tWIN32_FIND_DATA, $tFileTime, $IsDir, $callFindNext
	Local $DirectoryIndex = 0, $FileIndex = 0

	If $ArrayCount = 1 Then
		Local $FileArray[1], $DirectoryArray[1]
	Else
		Local $FileArray[1][$ArrayCount], $DirectoryArray[1][$ArrayCount]
	EndIf

	If $Return_Type < 0 Or $Return_Type > 2 Then Return SetError(1, 0, $FileArray)

;~ Global Const $tagWIN32_FIND_DATA = "DWORD dwFileAttributes; dword ftCreationTime[2]; dword ftLastAccessTime[2]; dword ftLastWriteTime[2]; DWORD nFileSizeHigh; DWORD nFileSizeLow; dword dwReserved0; dword dwReserved1; WCHAR cFileName[260]; WCHAR cAlternateFileName[14];"
	$tWIN32_FIND_DATA = DllStructCreate($tagWIN32_FIND_DATA)
	Local $callFindFirst = DllCall($__ghWinInet_FTP, 'handle', 'FtpFindFirstFileW', 'handle', $l_FTPSession, 'wstr', "", 'ptr', DllStructGetPtr($tWIN32_FIND_DATA), 'dword', $l_Flags, 'dword_ptr', $l_Context)
	If @error Or Not $callFindFirst[0] Then Return SetError(1, _WinAPI_GetLastError(), 0)

	Do
		$IsDir = BitAND(DllStructGetData($tWIN32_FIND_DATA, "dwFileAttributes"), $FILE_ATTRIBUTE_DIRECTORY) = $FILE_ATTRIBUTE_DIRECTORY
		If $IsDir And ($Return_Type <> 2) Then
			$DirectoryIndex += 1
			If $ArrayCount = 1 Then
				If UBound($DirectoryArray) < $DirectoryIndex+1 Then ReDim $DirectoryArray[$DirectoryIndex*2]
				$DirectoryArray[$DirectoryIndex] = DllStructGetData($tWIN32_FIND_DATA, "cFileName")
			Else
				If UBound($DirectoryArray) < $DirectoryIndex+1 Then ReDim $DirectoryArray[$DirectoryIndex*2][$ArrayCount]
				$DirectoryArray[$DirectoryIndex][0] = DllStructGetData($tWIN32_FIND_DATA, "cFileName")

				$DirectoryArray[$DirectoryIndex][1] = _WinAPI_MakeQWord(DllStructGetData($tWIN32_FIND_DATA, "nFileSizeLow"), DllStructGetData($tWIN32_FIND_DATA, "nFileSizeHigh"))
				If $ArrayCount = 6 Then
					$DirectoryArray[$DirectoryIndex][2] = DllStructGetData($tWIN32_FIND_DATA, "dwFileAttributes")

					$tFileTime = DllStructCreate($tagFILETIME, DllStructGetPtr($tWIN32_FIND_DATA, "ftLastWriteTime"))
					$DirectoryArray[$DirectoryIndex][3] = _Date_Time_FileTimeToStr( $tFileTime ,$bFmt)
					$tFileTime = DllStructCreate($tagFILETIME, DllStructGetPtr($tWIN32_FIND_DATA, "ftCreationTime"))
					$DirectoryArray[$DirectoryIndex][4] = _Date_Time_FileTimeToStr( $tFileTime ,$bFmt)
					$tFileTime = DllStructCreate($tagFILETIME, DllStructGetPtr($tWIN32_FIND_DATA, "ftLastAccessTime"))
					$DirectoryArray[$DirectoryIndex][5] = _Date_Time_FileTimeToStr( $tFileTime ,$bFmt)
				EndIf
			EndIf
		ElseIf Not $IsDir And $Return_Type <> 1 Then
			$FileIndex += 1
			If $ArrayCount = 1 Then
				If UBound($FileArray) < $FileIndex+1 Then ReDim $FileArray[$FileIndex*2]
				$FileArray[$FileIndex] = DllStructGetData($tWIN32_FIND_DATA, "cFileName")
			Else
				If UBound($FileArray) < $FileIndex+1 Then ReDim $FileArray[$FileIndex*2][$ArrayCount]
				$FileArray[$FileIndex][0] = DllStructGetData($tWIN32_FIND_DATA, "cFileName")

				$FileArray[$FileIndex][1] = _WinAPI_MakeQWord(DllStructGetData($tWIN32_FIND_DATA, "nFileSizeLow"), DllStructGetData($tWIN32_FIND_DATA, "nFileSizeHigh"))
				If $ArrayCount = 6 Then
					$FileArray[$FileIndex][2] = DllStructGetData($tWIN32_FIND_DATA, "dwFileAttributes")

					$tFileTime = DllStructCreate($tagFILETIME, DllStructGetPtr($tWIN32_FIND_DATA, "ftLastWriteTime"))
					$FileArray[$FileIndex][3] = _Date_Time_FileTimeToStr( $tFileTime ,$bFmt)
					$tFileTime = DllStructCreate($tagFILETIME, DllStructGetPtr($tWIN32_FIND_DATA, "ftCreationTime"))
					$FileArray[$FileIndex][4] = _Date_Time_FileTimeToStr( $tFileTime ,$bFmt)
					$tFileTime = DllStructCreate($tagFILETIME, DllStructGetPtr($tWIN32_FIND_DATA, "ftLastAccessTime"))
					$FileArray[$FileIndex][5] = _Date_Time_FileTimeToStr( $tFileTime ,$bFmt)
				EndIf
			EndIf
		EndIf

		$callFindNext = DllCall($__ghWinInet_FTP, 'bool', 'InternetFindNextFileW', 'handle', $callFindFirst[0], 'ptr', DllStructGetPtr($tWIN32_FIND_DATA))
		If @error Then Return SetError(2, _WinAPI_GetLastError(), 0)
	Until Not $callFindNext[0]

	DllCall($__ghWinInet_FTP, 'bool', 'InternetCloseHandle', 'handle', $callFindFirst[0])
	; No need to test @error.

	If $ArrayCount = 1 Then
		$DirectoryArray[0] = $DirectoryIndex
		$FileArray[0] = $FileIndex
	Else
		$DirectoryArray[0][0] = $DirectoryIndex
		$FileArray[0][0] = $FileIndex
	EndIf

	Switch $Return_Type
		Case 0
			If $ArrayCount = 1 Then
				ReDim $DirectoryArray[$DirectoryArray[0] + $FileArray[0] + 1]
				For $i = 1 To $FileIndex
					$DirectoryArray[$DirectoryArray[0] + $i] = $FileArray[$i]
				Next
				$DirectoryArray[0] += $FileArray[0]
			Else
				ReDim $DirectoryArray[$DirectoryArray[0][0] + $FileArray[0][0] + 1][$ArrayCount]
				For $i = 1 To $FileIndex
					For $j = 0 To $ArrayCount-1
					$DirectoryArray[$DirectoryArray[0][0] + $i][$j] = $FileArray[$i][$j]
					Next
				Next
				$DirectoryArray[0][0] += $FileArray[0][0]
			EndIf
			Return $DirectoryArray
		Case 1
			;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
			;ReDim $DirectoryArray[$DirectoryIndex+1]
			If $ArrayCount = 1 Then
				ReDim $DirectoryArray[$DirectoryIndex+1]
			Else
				ReDim $DirectoryArray[$DirectoryIndex+1][$ArrayCount]
			EndIf
			;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
			Return $DirectoryArray
		Case 2
			;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
			;ReDim $FileArray[$FileIndex +1]
			If $ArrayCount = 1 Then
				ReDim $FileArray[$FileIndex +1]
			Else
				ReDim $FileArray[$FileIndex +1][$ArrayCount]
			EndIf
			;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
			Return $FileArray
	EndSwitch
EndFunc   ;==>__FTP_ListToArray

